/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.operators.joins.spatial.utils.memory;

import org.apache.asterix.dataflow.data.nontagged.Coordinate;
import org.apache.asterix.dataflow.data.nontagged.serde.ADoubleSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt32SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ARectangleSerializerDeserializer;
import org.apache.asterix.om.base.APoint;
import org.apache.asterix.om.base.ARectangle;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class SpatialJoinUtil {
    private SpatialJoinUtil() {
    }

    public static ARectangle getRectangle(IFrameTupleAccessor accessor, int tupleId, int fieldId) throws HyracksDataException {
        int start = SpatialJoinUtil.getFieldOffset(accessor, tupleId, fieldId);
        double xmin = ADoubleSerializerDeserializer.getDouble((byte[])accessor.getBuffer().array(), (int)(start + ARectangleSerializerDeserializer.getBottomLeftCoordinateOffset((Coordinate)Coordinate.X)));
        double ymin = ADoubleSerializerDeserializer.getDouble((byte[])accessor.getBuffer().array(), (int)(start + ARectangleSerializerDeserializer.getBottomLeftCoordinateOffset((Coordinate)Coordinate.Y)));
        double xmax = ADoubleSerializerDeserializer.getDouble((byte[])accessor.getBuffer().array(), (int)(start + ARectangleSerializerDeserializer.getUpperRightCoordinateOffset((Coordinate)Coordinate.X)));
        double ymax = ADoubleSerializerDeserializer.getDouble((byte[])accessor.getBuffer().array(), (int)(start + ARectangleSerializerDeserializer.getUpperRightCoordinateOffset((Coordinate)Coordinate.Y)));
        return new ARectangle(new APoint(xmin, ymin), new APoint(xmax, ymax));
    }

    public static int getTileId(IFrameTupleAccessor accessor, int tupleId, int fieldId) {
        int start = SpatialJoinUtil.getFieldOffset(accessor, tupleId, fieldId);
        int tileId = AInt32SerializerDeserializer.getInt((byte[])accessor.getBuffer().array(), (int)start);
        return tileId;
    }

    public static double getRectangleXmin(IFrameTupleAccessor accessor, int tupleId, int fieldId) throws HyracksDataException {
        int start = SpatialJoinUtil.getFieldOffset(accessor, tupleId, fieldId);
        double xmin = ADoubleSerializerDeserializer.getDouble((byte[])accessor.getBuffer().array(), (int)(start + ARectangleSerializerDeserializer.getBottomLeftCoordinateOffset((Coordinate)Coordinate.X)));
        return xmin;
    }

    public static double getRectangleXmax(IFrameTupleAccessor accessor, int tupleId, int fieldId) throws HyracksDataException {
        int start = SpatialJoinUtil.getFieldOffset(accessor, tupleId, fieldId);
        double xmax = ADoubleSerializerDeserializer.getDouble((byte[])accessor.getBuffer().array(), (int)(start + ARectangleSerializerDeserializer.getUpperRightCoordinateOffset((Coordinate)Coordinate.X)));
        return xmax;
    }

    public static int getFieldOffset(IFrameTupleAccessor accessor, int tupleId, int fieldId) {
        return SpatialJoinUtil.getFieldOffsetWithTag(accessor, tupleId, fieldId) + 1;
    }

    public static int getFieldOffsetWithTag(IFrameTupleAccessor accessor, int tupleId, int fieldId) {
        int start = accessor.getTupleStartOffset(tupleId) + accessor.getFieldSlotsLength() + accessor.getFieldStartOffset(tupleId, fieldId);
        return start;
    }
}

