// Copyright The OpenTelemetry Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package schemagen

import (
	"reflect"
	"testing"

	"github.com/stretchr/testify/require"
)

func TestFieldComments(t *testing.T) {
	v := reflect.ValueOf(testStruct{})
	comments := commentsForStruct(v, testEnv())
	require.EqualValues(t, map[string]string{
		"Duration": "embedded, package qualified\n",
	}, comments)
}
