// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "pdata/internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package plog

import (
	"testing"

	"github.com/stretchr/testify/assert"

	"go.opentelemetry.io/collector/pdata/internal"
	"go.opentelemetry.io/collector/pdata/pcommon"
)

func TestScopeLogs_MoveTo(t *testing.T) {
	ms := generateTestScopeLogs()
	dest := NewScopeLogs()
	ms.MoveTo(dest)
	assert.Equal(t, NewScopeLogs(), ms)
	assert.Equal(t, generateTestScopeLogs(), dest)
}

func TestScopeLogs_CopyTo(t *testing.T) {
	ms := NewScopeLogs()
	orig := NewScopeLogs()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = generateTestScopeLogs()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
}

func TestScopeLogs_Scope(t *testing.T) {
	ms := NewScopeLogs()
	internal.FillTestInstrumentationScope(internal.InstrumentationScope(ms.Scope()))
	assert.Equal(t, pcommon.InstrumentationScope(internal.GenerateTestInstrumentationScope()), ms.Scope())
}

func TestScopeLogs_SchemaUrl(t *testing.T) {
	ms := NewScopeLogs()
	assert.Equal(t, "", ms.SchemaUrl())
	ms.SetSchemaUrl("https://opentelemetry.io/schemas/1.5.0")
	assert.Equal(t, "https://opentelemetry.io/schemas/1.5.0", ms.SchemaUrl())
}

func TestScopeLogs_LogRecords(t *testing.T) {
	ms := NewScopeLogs()
	assert.Equal(t, NewLogRecordSlice(), ms.LogRecords())
	fillTestLogRecordSlice(ms.LogRecords())
	assert.Equal(t, generateTestLogRecordSlice(), ms.LogRecords())
}

func generateTestScopeLogs() ScopeLogs {
	tv := NewScopeLogs()
	fillTestScopeLogs(tv)
	return tv
}

func fillTestScopeLogs(tv ScopeLogs) {
	internal.FillTestInstrumentationScope(internal.NewInstrumentationScope(&tv.orig.Scope))
	tv.orig.SchemaUrl = "https://opentelemetry.io/schemas/1.5.0"
	fillTestLogRecordSlice(newLogRecordSlice(&tv.orig.LogRecords))
}
